
library(readr)

mydata<-na.omit(mydata)

dev = mydata[mydata$Set==1,]
vad = mydata[mydata$Set==0,]



install.packages("rmda")
library(rmda)

#http://mdbrown.github.io/rmda/


###绘制DCA曲线

model_1<-decision_curve(PH ~Tibetan+Age+Gender+IRBBB+AF+ST+TC,
                        data = dev,
                        family = binomial(logit),
                        thresholds = seq(0,1,by=0.01),
                        confidence.intervals = 0.95,
                        study.design = 'case-control',
                        population.prevalence =0.4)



model_2<-decision_curve(PH2 ~Tibetan+Age+RAD+HVRV+IRBBB+AF+ST+TC+PP,
                        data = dev,
                        family = binomial(logit),
                        thresholds = seq(0,1,by=0.01),
                        confidence.intervals = 0.95,
                        study.design = 'case-control',
                        population.prevalence =0.1)


#绘制曲线
plot_decision_curve(model_1,curve.names = c('model_1'),
                    xlim = c(0,0.8),
                    cost.benefit.axis = FALSE,
                    col = c('blue'),
                    confidence.intervals = FALSE,
                    standardize = FALSE)


plot_decision_curve(model_2,curve.names = c('model_2'),
                    xlim = c(0,0.8),
                    cost.benefit.axis = FALSE,
                    col = c('red'),
                    confidence.intervals = FALSE,    #TRUE显示可信区间
                    standardize = FALSE)

#绘制多条曲线
plot_decision_curve( list(model_1, model_2), 
                     curve.names = c("model_1", "model_2"),
                     col = c("blue", "red"), 
                     confidence.intervals = FALSE,  #remove confidence intervals
                     cost.benefit.axis = FALSE, #remove cost benefit axis
                     legend.position = "topright") #remove the legend "bottomright""none""topright"
#添加可信区间
plot_decision_curve( list(model_1, model_2), 
                     curve.names = c("model_1", "model_2"),
                     col = c("blue", "red"), 
                     confidence.intervals = TRUE,  #confidence intervals
                     cost.benefit.axis = FALSE, #remove cost benefit axis
                     legend.position = "topright") #add the legend "bottomright" "topright" "none"



##验证集决策曲线，需要先生成验证集的预测概率
#fml8<-as.formula(hypoglycemia == 1 ~ course_of_disease + Hyperlipidemia + Treat_Time + 
                  # Education + gender + BUN + RBG + TC)
#fml7<-as.formula(hypoglycemia == 1 ~ course_of_disease + Hyperlipidemia + Treat_Time + 
                  # Education + BUN + RBG + TC)
fml8<-as.formula(PH2=="1"~Tibetan+Age+RAD+HVRV+IRBBB+AF+ST+TC+PP)

fml7<-as.formula(PH=="1"~Tibetan+Age+Gender+IRBBB+AF+ST+TC)

model8<-glm(fml8,data = dev,family = binomial(logit))

model7<-glm(fml7,data = dev,family = binomial(logit))


#在建模人群中计算预测值
dev$predmodel8<- predict(newdata=dev,model8,"response")
dev$predmodel7<- predict(newdata=dev,model7,"response")


#在验证人群计算预测值
vad$predmodel8<- predict(newdata=vad,model8,"response")
vad$predmodel7<- predict(newdata=vad,model7,"response")



#8因子模型
vadmodel8 <- decision_curve(PH2~predmodel8,
                             data = vad,
                             fitted.risk = TRUE, 
                             thresholds = seq(0, .9, by = .05),
                             bootstraps = 200) 

plot_decision_curve(vadmodel8,curve.names = c('model_2'),col = c('red'),
                    legend.position = "topright",
                    confidence.intervals = FALSE,    #remove confidence intervals)
                    standardize = FALSE) 


plot_decision_curve(vadmodel8,curve.names = c('model_2'),
                    legend.position = "topright",
                    confidence.intervals = TRUE,    #remove confidence intervals)
                    standardize = FALSE) 

#7因子模型
vadmodel7 <- decision_curve(PH~predmodel7,
                             data = vad,
                             fitted.risk = TRUE, 
                             thresholds = seq(0, .9, by = .05),
                             bootstraps = 200) 

plot_decision_curve(vadmodel7, curve.names = c('model_1'),col = c('blue'),legend.position = "topright",
                    confidence.intervals = FALSE,
                    standardize = FALSE)  #remove confidence intervals

#绘制多条曲线
plot_decision_curve( list(vadmodel8, vadmodel7), 
                     curve.names = c("model_1", "model_2"),
                     col = c("blue", "red"), 
                     confidence.intervals = FALSE,  #remove confidence intervals
                     cost.benefit.axis = FALSE, #remove cost benefit axis
                     legend.position = "topright") #remove the legend "bottomright" "topright" "none"


###################################################################################
#Decision Curve Analysis(DCA第二种方法)
##############################################################
##########决策曲线第二种方法(dca.R)-succeed
#https://www.mskcc.org/departments/epidemiology-biostatistics/biostatistics/decision-curve-analysis

#返回模型 1的画图数据
setwd("D:/R work")
source("dca.r")

df <- as.data.frame(dev)
model <- glm(PH2~Tibetan+Age+RAD+HVRV+IRBBB+AF+ST+TC+PP,family = binomial(),data = df)
df$nomogram <- predict(model,type="response")

Age <- glm(PH2 ~  Age ,  family = binomial(),data=df)
df$Age <- predict(Age, type="response")

dca(data=df, outcome="PH2", 
    predictors=c("nomogram","Age","Tibetan","RAD","HVRV","IRBBB","AF","ST","TC","PP"),
    smooth="TRUE", probability=c(T,T,F,F,F,F,F,F,F,F),
    xstop=0.8,) 

df <- as.data.frame(vad)
model <- glm(PH~Tibetan+Age+Gender+IRBBB+AF+ST+TC,family = binomial(),data = df)
df$nomogram <- predict(model,type="response")

Age <- glm(PH ~  Age ,  family = binomial(),data=df)
df$Age <- predict(Age, type="response")

dca(data=df, outcome="PH", 
    predictors=c("nomogram","Age","Tibetan","Gender","IRBBB","AF","ST","TC"),
    smooth="TRUE", probability=c(T,T,F,F,F,F,F,F),
    xstop=1.0,) 

setwd("D:/R work")
source("dca.r")

df <- as.data.frame(val)
model <- glm(PH2~Tibetan+Age+RAD+HVRV+IRBBB+AF+ST+TC+PP,family = binomial(),data = df)
df$nomogram <- predict(model,type="response")

dca(data=df, outcome="PH2", predictors="nomogram",
    probability = T,
    xstop=0.9 #控制 x轴范围
)








dca_data1 <- dca(data = df,
                 outcome="PH2",
                 predictors="nomogram",
                 probability = T,
                 graph = F
)
#然后提取数据，数据转换：


#转换数据
library(tidyr)
dca_df1 <- dca_data1$net.benefit %>% #画图数据就藏在这里！
  #变成长数据,还不懂长宽数据转换这个超强操作的快去翻一下历史文章！
  pivot_longer(cols = -threshold, names_to = "type", values_to = "net_benefit")
#看下数据结构
str(dca_df1)
## tibble [297 x 3] (S3: tbl_df/tbl/data.frame)
## $ threshold : num [1:297] 0.01 0.01 0.01 0.02 0.02 0.02 0.03 0.03 0.03 0.04 ...
## $ type : chr [1:297] "all" "none" "prob" "all" ...
## $ net_benefit: num [1:297] 0.111 0 0.11 0.102 0
library(ggplot2)
## Warning: package 'ggplot2' was built under R version 4.2.3
library(ggsci)

#以 prob这个模型为例
#X<-ggplot(dca_df1, aes(x=threshold, y=net_benefit, color = type))+
  geom_line(linewidth = 1.2)+
  scale_color_jama(name = "Model Type")+ # c("steelblue","firebrick","green4")
  scale_y_continuous(limits = c(-0.1,0.4),name = "Net Benefit")+
  #限定 y轴范围是重点，你可以去掉这句看看
  scale_x_continuous(limits = c(0,1),name = "Threshold Probility")+
  theme_bw(base_size = 16)+
  theme(legend.position = c(0.8,0.8),
        legend.background = element_blank())



p1<-ggplot(dca_df1)+
  geom_line(aes(x=threshold,y=net_benefit,color=type),linewidth=1.2)+
  scale_color_jama(name="Model Types",
                   labels=c("All","nomogram","None"))+
  scale_x_continuous(labels=scales::label_percent(accuracy=1),
                     name="Threshold Probility")+
  scale_y_continuous(limits=c(-0.05,0.08),name="Net Benefit")+
  theme_bw(base_size=16)+
  theme(legend.background=element_blank(),
        legend.position=c(0.85,0.75))


p1

rect_df1<-data.frame(xmin = 0,
                       xmax = 0.01,
                       ymin = -0.025,
                       ymax = -0.05)
rect_df2<-data.frame(xmin = 0.01,
                       xmax = 0.70,
                       ymin = -0.025,
                       ymax = -0.05)
rect_df3<-data.frame(xmin=0.70,xmax=1,ymin= -0.025,ymax= -0.05)


                 p2<-p1+
                      geom_rect(data=rect_df1,
                                   mapping=aes(xmin=xmin,xmax=xmax,ymin=ymin,ymax=ymax),
                                   fill="#0151a2")+
                         geom_rect(data=rect_df2,
                                   mapping=aes(xmin=xmin,xmax=xmax,ymin=ymin,ymax=ymax),
                                   fill="#c01e35")+
                         geom_rect(data=rect_df3,
                                   mapping=aes(xmin=xmin,xmax=xmax,ymin=ymin,ymax=ymax),
                                   fill="#0151a2")+
                         annotate(geom="text",label="Nomogram relevant",
                                  x=0.4,y=-0.035,
                                  size=5,color="white")
                       p2
                       line_df<-data.frame(x=c(0.01,0.70),
                                            ymin=c(-0.05,-0.05),
                                            ymax=c(0.08,0))
                       
                       p3<-p2+geom_linerange(data=line_df,mapping=aes(x=x,ymin=ymin,ymax=ymax),
                                         linetype=2,linewidth=1,colour="grey")
                       p3
                       
## Warning: Removed 85 rows containing missing values (`geom_line()`).
#下面是 2个模型画在一起的例子，和上面的思路一模一样！
#构建模型 2
Age <- glm(PH2 ~  Age ,  family = binomial(),data=df)
df$Age <- predict(Age, type="response")


#PH2~Tibetan+Age+RAD+HVRV+IRBBB+AF+ST+TC+PP
#返回两个模型的画图数据
dca12 <- dca(data = df,
             outcome="PH2",
             predictors=c("nomogram","Age","Tibetan","RAD","HVRV","IRBBB","AF","ST","TC","PP") ,
             probability = c(T,T,F,F,F,F,F,F,F,F),
             graph = F
)
#合并数据，大家可以打开这 2个数据看下，可以直接合并
library(dplyr)
## Warning: package 'dplyr' was built under R version 4.2.3
##
## Attaching package: 'dplyr'
## The following objects are masked from 'package:stats':
##
## filter, lag
## The following objects are masked from 'package:base':
##
## intersect, setdiff, setequal, union
dca_df_all <- dca12$net.benefit %>%
  pivot_longer(cols = -threshold,names_to = "models",values_to = "net_benefit")
glimpse(dca_df_all)
## Rows: 396
## Columns: 3
## $ threshold <dbl> 0.01, 0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.03, 0.03~
## $ models <chr> "all", "none", "prob", "model2", "all", "none", "prob", "m~
## $ net_benefit <dbl> 0.11111111, 0.00000000, 0.10957576, 0.11111111, 0.10204082~
#画图也是一样的简单：
ggplot(dca_df_all, aes(threshold, net_benefit, color = models))+
  #geom_line(size = 1.2)+
  stat_smooth(method = "loess", se = FALSE, formula = "y ~ x", span = 0.2)+
  #灵感来自于方法 5！
  scale_color_jama(name = "Model Types")+
  scale_y_continuous(limits = c(-0.025,0.1),name = "Net Benefit")+
  scale_x_continuous(limits = c(0,1),name = "Threshold Probility")+
  theme_bw(base_size = 16)+
  theme(legend.position = c(0.8,0.75),
        legend.background = element_blank()
  )

ggplot(dca_df_all)+
  geom_line(aes(x=threshold,y=net_benefit,color=models),linewidth=1.2)+
  scale_color_jama(name="Model Types",
                   labels=c("All","nomogram","None","Age","Tibetan","RAD","HVRV","IRBBB","AF","ST","TC","PP"))+
  scale_x_continuous(labels=scales::label_percent(accuracy=1),
                     name="Threshold Probility")+
  scale_y_continuous(limits=c(-0.05,0.08),name="Net Benefit")+
  theme_bw(base_size=16)+
  theme(legend.background=element_blank(),
        legend.position=c(0.85,0.75))
## Warning: Removed 85 rows containing non-finite values (`stat_smooth()`).
## Warning in simpleLoess(y, x, w, span, degree = degree, parametric = parametric,







library(readr)
mydata <- read_csv("hypoglycemia_end.csv")


dev = mydata[mydata$Set==1,]
vad = mydata[mydata$Set==0,]

source("dca.R")
#install.packages("nricens")

library(rms)
library(foreign)
library(nricens)

#构建2个回归模型用于演示
##modelA为8因素模型
modelA<-glm(hypoglycemia ~course_of_disease + Hyperlipidemia + Treat_Time + 
              Education + BUN + gender+ RBG + TC, data = dev, family = binomial(link="logit"),x=TRUE)
summary(modelA)

#用modelA预测概率（建模集和验证集)
dev$predmodelA<- predict(newdata=dev,modelA,"response")
vad$predmodelA<- predict(newdata=vad,modelA,"response")

#is.data.frame(dev)
#View(dev)
View(vad)

#modelD为7因素最优模型
modelD <- glm(hypoglycemia ~course_of_disease + Hyperlipidemia + Treat_Time + 
                Education + BUN + RBG + TC, data = dev, family = binomial(link="logit"),x=TRUE)
summary(modelD)

#用modelD预测概率（建模集和验证集)
dev$predmodelD<- predict(newdata=dev,modelD,"response")
vad$predmodelD<- predict(newdata=vad,modelD,"response")

View(dev)

#训练集dca
dev<-as.data.frame(dev)
dca(data=dev, outcome="hypoglycemia",
    predictors=c("predmodelA","predmodelD"),
    smooth="TRUE", probability=c("TRUE","TRUE"),
    xstop=0.5) 


#验证集dca
vad<-as.data.frame(vad)
dca(data=vad, outcome="hypoglycemia", 
    predictors=c("predmodelA","predmodelD"),
    smooth="TRUE", probability=c("TRUE","TRUE"),
    xstop=0.5) 

#可以直接添加自变量predictors，如下面加入TC
dca(data=df, outcome="PH2", 
    predictors=c("nomogram","Age","Tibetan","RAD","HVRV","IRBBB","AF","ST","TC","PP"),
    smooth="TRUE", probability=c(T,T,F,F,F,F,F,F,F,F),
    xstop=0.8,) 

##############################################################
#----------------dca.R帮助文档---注意可以直接放预测因子-------
##############################################################
library(MASS)
data.set <- birthwt
#data.set
View(data.set)

model = glm(low ~ age + lwt, family=binomial(link="logit"), data=data.set)
data.set$predlow = predict(model, type="response")

#Decision Curve Analysis
dca(data=data.set, outcome="low", predictors="predlow", smooth="TRUE", xstop=0.50)               #predictors为预测概率

dca(data=data.set, outcome="low", predictors=c("age", "lwt"), probability=c("FALSE", "FALSE"))   #predictors为方程中的变量，而且可以多个

dca(data=data.set, outcome="low", predictors="age", smooth="TRUE", xstop=0.50, probability="FALSE", intervention="TRUE")   #百人干预净获益减少曲线



